//---------------------------------------------------------------------------
//  Base 64 Encode/Decode unit. (C)
//  Copyright (c) 2000, 01 Mental Studio - http://msrc.126.com
//  Author : Raptor - raptorz@163.com
//---------------------------------------------------------------------------
//
//  Ҫ Delphi 뱾Ԫ StrCrypt.obj ļ
//  bcc32 -c -pr -O2 -C -K -N- -k- -d -3 -r- StrCrypt.c
//  ֱΪ
//  -c  Ϊ obj ļ
//  -pr  Pascal  fastcall ÷ʽ
//  -O2 ŻѡΪ2
//  -C  Ƕע
//  -K  Ĭʹ޷ַ
//  -N- ջ
//  -k- ʹñ׼ջ
//  -d  ϲظַ
//  -3  ʹ 386 ָ
//  -r- δ֪^_^

#include <string.h>
#include "StrCrypt.h"

//---------------------------------------------------------------------------
//  Base64 code table
//  0-63 : A-Z(25) a-z(51), 0-9(61), +(62), /(63)
char  Base2Chr( unsigned char n )
{
	n &= 0x3F;
	if ( n < 26 )
    	return ( char )( n + 'A' );
    else if ( n < 52 )
    	return ( char )( n - 26 + 'a' );
    else if ( n < 62 )
    	return ( char )( n - 52 + '0' );
    else if ( n == 62 )
    	return '+';
    else
    	return '/';
}
//---------------------------------------------------------------------------
unsigned char Chr2Base( char c )
{
	if ( c >= 'A' && c <= 'Z' )
    	return ( unsigned char )( c - 'A' );
    else if ( c >= 'a' && c <= 'z' )
    	return ( unsigned char )( c - 'a' + 26 );
    else if ( c >= '0' && c <= '9' )
    	return ( unsigned char )( c - '0' + 52 );
    else if ( c == '+' )
    	return 62;
    else
    	return 63;
}
//---------------------------------------------------------------------------
//  ݱΪַ
//  aSize Ϊ aData ĴС aStr ָĻΪ aSize  4/3 
//   aStr ĳ
int EncodeStr( char * const aStr, const unsigned char * aData, int aSize )
{
	char        * p = aStr;
    int           i;
    unsigned char t;

    for ( i = 0; i < aSize; i++ )
    {
    	switch ( i % 3 )
        {
        case 0 :
        	*p++ = Base2Chr( *aData >> 2 );
            t = ( *aData++ << 4 ) & 0x3F;
            break;
        case 1 :
        	*p++ = Base2Chr( t | ( *aData >> 4 ) );
            t = ( *aData++ << 2 ) & 0x3F;
            break;
        case 2 :
        	*p++ = Base2Chr( t | ( *aData >> 6 ) );
            *p++ = Base2Chr( *aData++ );
            break;
        }
    }
    if ( aSize % 3 != 0 )
    {
    	*p++ = Base2Chr( t );
        if ( aSize % 3 == 1 )
        	*p++ = '=';
        *p++ = '=';
    }
    *p = 0;  //  aStr is an ASCIIZ string
	return ( p - aStr );  //  exclude the end of zero
}
//---------------------------------------------------------------------------
//  ѱַΪ
//  aData ָĻΪ aStr ȵ 0.75 
//   aData ĳ
int DecodeStr( unsigned char * const aData, const char * aStr )
{
	unsigned char * p = aData;
    int             i, n = strlen( aStr );
    unsigned char   c, t;

    for ( i = 0; i < n; i++ )
    {
    	if ( *aStr == '=' )
        	break;
       	c = Chr2Base( *aStr++ );
        switch ( i % 4 )
        {
        case 0 :
        	t = c << 2;
            break;
        case 1 :
        	*p++ = ( unsigned char )( t | ( c >> 4 ) );
            t = ( unsigned char )( c << 4 );
            break;
        case 2 :
        	*p++ = ( unsigned char )( t | ( c >> 2 ) );
            t = ( unsigned char )( c << 6 );
            break;
        case 3 :
        	*p++ = ( unsigned char )( t | c );
        	break;
        }
    }
	return ( p - aData );
}
//---------------------------------------------------------------------------

