//---------------------------------------------------------------------------
//  Data Encrypt/Decrypt unit. (PAS)
//  Copyright (c) 2000, 01 Mental Studio - http://msrc.126.com
//  Author : Raptor - raptorz@163.com
//---------------------------------------------------------------------------
unit DataCrypt;

interface

Uses
    Classes, SysUtils;

Type
    PByte = ^Byte;

Function  Data2Str( aData : TMemoryStream ) : String;
Procedure Str2Data( aDest : TMemoryStream; aSrc : String );

Procedure DataEncrypt( aData : TMemoryStream; const aKey : Pointer );
Procedure DataDecrypt( aData : TMemoryStream; const aKey : Pointer );

Function  StrEncrypt( aSrc : String; const aKey : Pointer ) : String;
Function  StrDecrypt( aSrc : String; const aKey : Pointer ) : String;

implementation

{$L StrCryptd.obj}

Function  EncodeStr( const aStr  : PChar; const aData : PByte; aSize : Integer ) : Integer; External;
Function  DecodeStr( const aData : PByte; const aStr  : PChar                  ) : Integer; External;

{$L Tead.obj}

Procedure Encipher( aData : Pointer; const aKey : Pointer ); External;
Procedure Decipher( aData : Pointer; const aKey : Pointer ); External;

//  ΪDELPHIstring.hеĺҪдô
Function _strlen( aStr : PChar ) : Integer; cdecl;
Begin
	Result := Length( aStr );
End;

//  Ϊַ
//  aData ΪԴ
//  ؽַ
Function  Data2Str( aData : TMemoryStream ) : String;
Var
    buf : TMemoryStream;
Begin
    buf := TMemoryStream.Create;
    Try
        buf.Size := aData.Size * 4 DIV 3 + 1;
        EncodeStr( PChar( buf.Memory ), PByte( aData.Memory ), aData.Size );
        Result := PChar( buf.Memory );
    Finally
    	buf.Free;
    End;
End;

//  ַнѱ
//  aDest Ϊ aSrc ΪԴַ
Procedure Str2Data( aDest : TMemoryStream; aSrc : String );
Begin
    aDest.Size := Length( aSrc ) + 1;
    aDest.Size := DecodeStr( PByte( aDest.Memory ), PChar( aSrc ) );
End;

//  
//  aData Ϊ aKey Կ(128bit)
Procedure DataEncrypt( aData : TMemoryStream; const aKey : Pointer );
Var
    nSize : Integer;
    n     : Integer;
    p     : PByte;
Begin
    nSize := aData.Size;       //  ΪСܻб仯Ҫ¼ԭʼС
    n := ( nSize + 7 ) SHR 3;  //   8Bytes(64bits) 
    aData.Size := n SHL 3;
    p := PByte( aData.Memory );
    Inc( p, nSize );
    FillChar( p^, aData.Size - nSize, 0 );
    p := PByte( aData.Memory );

	While ( n > 0 ) Do
    Begin
        Dec( n );
    	Encipher( p, aKey );
        Inc( p, 8 );
    End;
    aData.Seek( 0, soFromEnd );
    aData.Write( nSize, SizeOf( nSize ) );  //  ԭʼС¼ĩ
End;

//  
//  aData Ϊ aKey Կ(128bit)
Procedure DataDecrypt( aData : TMemoryStream; const aKey : Pointer );
Var
    nSize : Integer;
    n     : Integer;
    p     : PByte;
Begin
    n := SizeOf( nSize );
	aData.Seek( -n, soFromEnd );  //  ȡԭʼС
    aData.Read( nSize, n );

	n := aData.Size - n;
    aData.Size := n;
    n := ( n + 7 ) SHR 3;  //   8Bytes(64bits) 
    If ( aData.Size <> ( n SHL 3 ) ) Then
        Raise Exception.Create( 'Invalid data size!' );
    p := PByte( aData.Memory );

	While ( n > 0 ) Do
    Begin
        Dec( n );
    	Decipher( p, aKey );
        Inc( p, 8 );
    End;
    aData.Size := nSize;
End;

//  ַ
//  aSrc ΪԴַ aKey Կ(128bit)
//  Ϊַ
Function  StrEncrypt( aSrc : String; const aKey : Pointer ) : String;
Var
    buf : TMemoryStream;
Begin
    buf := TMemoryStream.Create;
    Try
    	buf.Size := Length( aSrc ) + 1;
        FillChar( PByte( buf.Memory )^, buf.Size, 0 );
        StrCopy( PChar( buf.Memory ), PChar( aSrc ) );
        DataEncrypt( buf, aKey );
        Result := Data2Str( buf );
    Finally
    	buf.Free;
    End;
End;

//  ַ
//  aSrc ΪԴַ aKey Կ(128bit)
//  Ϊַ
Function  StrDecrypt( aSrc : String; const aKey : Pointer ) : String;
Var
    buf : TMemoryStream;
Begin
    buf := TMemoryStream.Create;
    Try
    	Str2Data( buf, aSrc );
        DataDecrypt( buf, aKey );
        Result := PChar( buf.Memory );
    Finally
    	buf.Free;
    End;
End;

end.

