//---------------------------------------------------------------------------
//  Data Encrypt/Decrypt unit. (CPP)
//  Copyright (c) 2000, 01 Mental Studio - http://msrc.126.com
//  Author : Raptor - raptorz@163.com
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "DataCrypt.h"
#include "StrCrypt.h"
#include "Tea.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

//---------------------------------------------------------------------------
//  Ϊַ
//  aData ΪԴ
//  ؽַ
AnsiString Data2Str( TMemoryStream * aData )
{
	TMemoryStream * buf;
    AnsiString s;

    buf = new TMemoryStream( );
    try
    {
        buf->Size = aData->Size * 4 / 3 + 1;
        EncodeStr( ( char * )buf->Memory, ( unsigned char * )aData->Memory, aData->Size );
        s = AnsiString( ( char * )buf->Memory );
    }
    __finally
    {
    	delete buf;
    }
    return s;
}
//---------------------------------------------------------------------------
//  ַнѱ
//  aDest Ϊ aSrc ΪԴַ
void Str2Data( TMemoryStream * aDest, AnsiString aSrc )
{
    aDest->Size = aSrc.Length( ) + 1;
    aDest->Size = DecodeStr( ( unsigned char * )aDest->Memory, aSrc.c_str( ) );
    return;
}
//---------------------------------------------------------------------------
//  
//  aData Ϊ aKey Կ(128bit)
void DataEncrypt( TMemoryStream * aData, const void * aKey )
{
	int nSize = aData->Size;     //  ΪСܻб仯Ҫ¼ԭʼС
	int n = ( nSize + 7 ) >> 3;  //   8Bytes(64bits) 
    aData->Size = n << 3;
    unsigned char * p = ( unsigned char * )aData->Memory;
	p += nSize;
	memset( p, 0, aData->Size - nSize );
	p = ( unsigned char * )aData->Memory;

	while ( n-- )
    {
    	Encipher( p, aKey );
        p += 8;
    }
    aData->Seek( 0, soFromEnd );
    aData->Write( &nSize, sizeof ( nSize ) );  //  ԭʼС¼ĩ
}
//---------------------------------------------------------------------------
//  
//  aData Ϊ aKey Կ(128bit)
void DataDecrypt( TMemoryStream * aData, const void * aKey )
{
	int nSize;
	int n = sizeof ( nSize );

	aData->Seek( -n, soFromEnd );  //  ȡԭʼС
    aData->Read( &nSize, n );

	n = aData->Size - n;
    aData->Size = n;
    n = ( n + 7 ) >> 3;  //   8Bytes(64bits) 
    if ( aData->Size != ( n << 3 ) )
    	throw "Invalid data size!";
    unsigned char * p = ( unsigned char * )aData->Memory;

	while ( n-- )
    {
    	Decipher( p, aKey );
        p += 8;
    }
    aData->Size = nSize;
}
//---------------------------------------------------------------------------
//  ַ
//  aSrc ΪԴַ aKey Կ(128bit)
//  Ϊַ
AnsiString StrEncrypt( AnsiString aSrc, const void * aKey )
{
	AnsiString      s;
	TMemoryStream * buf;

    buf = new TMemoryStream( );
    try
    {
    	buf->Size = aSrc.Length( ) + 1;
		memset( buf->Memory, 0, buf->Size );
        strcpy( ( char * )buf->Memory, aSrc.c_str( ) );
        DataEncrypt( buf, aKey );
        s = Data2Str( buf );
    }
    __finally
    {
    	delete buf;
    }
    return s;
}
//---------------------------------------------------------------------------
//  ַ
//  aSrc ΪԴַ aKey Կ(128bit)
//  Ϊַ
AnsiString StrDecrypt( AnsiString aSrc, const void * aKey )
{
	AnsiString      s;
	TMemoryStream * buf;

    buf = new TMemoryStream( );
    try
    {
    	Str2Data( buf, aSrc );
        DataDecrypt( buf, aKey );
        s = ( char * )buf->Memory;
    }
    __finally
    {
    	delete buf;
    }
    return s;
}
//---------------------------------------------------------------------------

